function [soc_new, battCurr, battUnfeas, battPrf] = battModel_charging(soc, battCurr, batt, dt)

%% Battery
% Battery internal resistance
battEqRes = batt.eqRes(soc);
% Battery voltage
battOCVolt = batt.ocVolt(soc);

% Battery state of charge update
% columbic efficiency
battColumbicEff = ( battCurr > 0 ) + ( battCurr <= 0 ) .* batt.coulombicEff;
soc_new  = - battColumbicEff .* battCurr ./ (batt.actualCap * 3600) .* dt + soc;

% Constraints
battUnfeas = ( battCurr > batt.maxCurr ) | ( battCurr < batt.minCurr ) | ...
    ( soc_new < batt.SOC_lb ) | ( soc_new > batt.SOC_ub );

%% Pack profiles
if isscalar(soc)
    battPrf.battSOC = soc;
    battPrf.battCurr = battCurr;
    battPrf.battOCVolt = battOCVolt;
    battPrf.battVolt = battOCVolt - battCurr * battEqRes;
    battPrf.battEqRes = battEqRes;
    battPrf.battUnfeas = battUnfeas;
else
    battPrf = [];
end

end